using System;
using System.Threading;

namespace UczenCzarnoksieznika
{	
  interface IUczenPowiadomi
  {
    void PracaRozpoczeta();
    void PracaTrwa();
    int  PracaZakonczona();
  }
  
  class Uczen
  {
    public void PoradzSie( IUczenPowiadomi uczenpowiadomi )
    {
      _uczenpowiadomi = uczenpowiadomi;  	
    }
    public void Pracuj()
    {
      Console.WriteLine( "Uczen: rozpoczynam prace." );
      if ( _uczenpowiadomi != null ) _uczenpowiadomi.PracaRozpoczeta();
  		
      Console.WriteLine( "Uczen: pracuje." );
      if ( _uczenpowiadomi != null ) _uczenpowiadomi.PracaTrwa();
  	  
      Console.WriteLine( "Koncze prace." );
      if ( _uczenpowiadomi != null ) 
      {
        int ocena = _uczenpowiadomi.PracaZakonczona();
        Console.WriteLine( "Ocena : {0}", ocena );
      }
    }
    private IUczenPowiadomi _uczenpowiadomi;
  }
  
  class Czarnoksieznik : IUczenPowiadomi
  {
    public void PracaRozpoczeta() { }
    public void PracaTrwa()       { }
    public int PracaZakonczona() 
    {
      Console.WriteLine( "Ach, znakomicie!" );
      return 3;
    }
  }
  
  class Uniwersum
  {
    public static void Main()
    {
      Uczen uczen = new Uczen();
      Czarnoksieznik czarnoksieznik = new Czarnoksieznik();
  		
      uczen.PoradzSie( czarnoksieznik );  		
      uczen.Pracuj();
    }
  }
}
